/*
  BajaScript has an RPC mechanism to invoke Java methods on the Server.
  To implement this, first create a Java Niagara class that implements this interface...
  
  box:javax.baja.box.BIServerSideCallHandler
  
  Please read the class header to see how to format the Java methods.
  Your new class should be registered as an Agent on a Component Type.
  When registering the Agent, remember to specify the security permissions (readPermissions).
  In the example below, the Server Side Call Handler is registered as an
  Agent on the Tutorials App Component. An instance of the App is then resolved
  (security is checked) and then Server Side Call methods
  can then be invoked. Please note, Server Side Call Handlers can be registered
  on virtually any Component Type.
  
  The great thing is you can use Niagara Types for the argument and return
  Types seemlessly.
  
  Please note how Server Side Calls are completely asynchronous.
  
  Tip: if you require multiple arguments to a Server Side Call, just batch
  them up into a baja.Component.
  
  Why have an RPC mechanism like this? Even though BajaScript can do a lot,
  it sometimes makes sense to get something 'done' in the Server instead of the
  client. For instance, saving on bandwith or accessing a file etc.
*/

// Resolve the Tutorials App (since our Server Side Call handler is declared
// as an Agent on this Type)...
baja.Ord.make("service:testBajaScript:BajaScriptTutorialsApp").get({
  ok: function() {
    // Invoke a Java method named 'hello' in the Server and show the response!
    this.serverSideCall({
      typeSpec: "testBajaScript:ConsoleServerSideHandler",
      methodName: "hello",
      value: "Thomas", // This is the argument for the Server Side Call
      ok: function(response) {
        // Output the response from the Server.
        baja.outln(response);
      }
    });
  },
  lease: true
});